/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPCEventLTV;
import apicore.message.UUID;
import apicore.ptmp.PacketTracerSession;
import apiipc.generated.events.PortEvent;
import apiipc.generated.events.PortEventListener;
import apiipc.generated.sim.Port;
import apiipc.ipc.IPCEventRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortEventRegistry
extends IPCEventRegistry {
    protected Set<PortEventListener> globalListeners = new HashSet<PortEventListener>();
    protected Map<String, Set<PortEventListener>> specificObjectListeners = new HashMap<String, Set<PortEventListener>>();

    public PortEventRegistry(PacketTracerSession packetTracerSession) {
        super(packetTracerSession);
    }

    @Override
    public String getClassName() {
        return "Port";
    }

    @Override
    public void processEvent(IPCEventLTV iPCEventLTV) {
        String string = iPCEventLTV.getEventName();
        PortEvent portEvent = null;
        if (string.equalsIgnoreCase("powerChanged")) {
            portEvent = new PortEvent.PowerChanged(iPCEventLTV);
        } else if (string.equalsIgnoreCase("macChanged")) {
            portEvent = new PortEvent.MacChanged(iPCEventLTV);
        } else if (string.equalsIgnoreCase("lightStatusChanged")) {
            portEvent = new PortEvent.LightStatusChanged(iPCEventLTV);
        } else if (string.equalsIgnoreCase("lightBlinked")) {
            portEvent = new PortEvent.LightBlinked(iPCEventLTV);
        } else if (string.equalsIgnoreCase("packetReceived")) {
            portEvent = new PortEvent.PacketReceived(iPCEventLTV);
        } else if (string.equalsIgnoreCase("portStatusChanged")) {
            portEvent = new PortEvent.PortStatusChanged(iPCEventLTV);
        } else if (string.equalsIgnoreCase("lineProtocolChanged")) {
            portEvent = new PortEvent.LineProtocolChanged(iPCEventLTV);
        } else {
            return;
        }
        for (PortEventListener object : this.globalListeners) {
            object.handleEvent(portEvent);
        }
        Set<PortEventListener> set = this.specificObjectListeners.get(portEvent.objectUUID.toString());
        if (set != null) {
            for (PortEventListener portEventListener : set) {
                portEventListener.handleEvent(portEvent);
            }
        }
    }

    public void addListenerFiltered(PortEventListener portEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.register("powerChanged");
                this.register("macChanged");
                this.register("lightStatusChanged");
                this.register("lightBlinked");
                this.register("packetReceived");
                this.register("portStatusChanged");
                this.register("lineProtocolChanged");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        this.globalListeners.add(portEventListener);
    }

    public void addSpecificListenerFiltered(PortEventListener portEventListener, Port port, List<String> list) throws IOException {
        UUID uUID = port.getObjectUUID();
        String string = uUID.toString();
        Set<PortEventListener> set = this.specificObjectListeners.get(string);
        if (set == null) {
            set = new HashSet<PortEventListener>();
            this.specificObjectListeners.put(string, set);
            if (list == null) {
                this.register(uUID, "powerChanged");
                this.register(uUID, "macChanged");
                this.register(uUID, "lightStatusChanged");
                this.register(uUID, "lightBlinked");
                this.register(uUID, "packetReceived");
                this.register(uUID, "portStatusChanged");
                this.register(uUID, "lineProtocolChanged");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(uUID, list.get(i));
                }
            }
        }
        set.add(portEventListener);
    }

    public void removeListenerFiltered(PortEventListener portEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (list == null) {
                this.deregister("powerChanged");
                this.deregister("macChanged");
                this.deregister("lightStatusChanged");
                this.deregister("lightBlinked");
                this.deregister("packetReceived");
                this.deregister("portStatusChanged");
                this.deregister("lineProtocolChanged");
            }
            this.globalListeners.remove(portEventListener);
        }
    }

    public void removeSpecificListenerFiltered(PortEventListener portEventListener, Port port, List<String> list) throws IOException {
        UUID uUID = port.getObjectUUID();
        String string = uUID.toString();
        Set<PortEventListener> set = this.specificObjectListeners.get(string);
        if (set != null && !set.isEmpty()) {
            this.deregister(uUID, "powerChanged");
            this.deregister(uUID, "macChanged");
            this.deregister(uUID, "lightStatusChanged");
            this.deregister(uUID, "lightBlinked");
            this.deregister(uUID, "packetReceived");
            this.deregister(uUID, "portStatusChanged");
            this.deregister(uUID, "lineProtocolChanged");
            set.remove(portEventListener);
        }
    }

    public void addListener(PortEventListener portEventListener) throws IOException {
        this.addListenerFiltered(portEventListener, null);
    }

    public void addListener(PortEventListener portEventListener, Port port) throws IOException {
        this.addSpecificListenerFiltered(portEventListener, port, null);
    }

    public void removeListener(PortEventListener portEventListener) throws IOException {
        this.removeListenerFiltered(portEventListener, null);
    }

    public void removeListener(PortEventListener portEventListener, Port port) throws IOException {
        this.removeSpecificListenerFiltered(portEventListener, port, null);
    }
}

